"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    TASK_ACTIONS: function() {
        return TASK_ACTIONS;
    },
    TASK_DELETE_BY_SYSTEM_REASON: function() {
        return TASK_DELETE_BY_SYSTEM_REASON;
    },
    TASK_DELETE_PATIENT_DISCHARGED_REASON_ID: function() {
        return TASK_DELETE_PATIENT_DISCHARGED_REASON_ID;
    },
    TASK_DELETE_RECORDED_IN_ERROR_REASON_ID: function() {
        return TASK_DELETE_RECORDED_IN_ERROR_REASON_ID;
    },
    TASK_DURATION_UNIT: function() {
        return TASK_DURATION_UNIT;
    },
    TASK_DURATION_UNIT_LABELS: function() {
        return TASK_DURATION_UNIT_LABELS;
    },
    TASK_FREQUENCY_ACCEPTED_UNITS: function() {
        return TASK_FREQUENCY_ACCEPTED_UNITS;
    },
    TASK_FREQUENCY_ACCEPTED_UNITS_TO_VALUE: function() {
        return TASK_FREQUENCY_ACCEPTED_UNITS_TO_VALUE;
    },
    TASK_FREQUENCY_UNIT: function() {
        return TASK_FREQUENCY_UNIT;
    },
    TASK_FREQUENCY_UNIT_LABELS: function() {
        return TASK_FREQUENCY_UNIT_LABELS;
    },
    TASK_NOTE_COMPLETE_OVERDUE_REASON_ID: function() {
        return TASK_NOTE_COMPLETE_OVERDUE_REASON_ID;
    },
    TASK_STATUSES: function() {
        return TASK_STATUSES;
    }
});
const TASK_STATUSES = {
    TODO: 'todo',
    COMPLETED: 'completed',
    NON_COMPLETED: 'non_completed'
};
const TASK_ACTIONS = {
    TODO: 'todo',
    COMPLETED: 'completed',
    NON_COMPLETED: 'non_completed',
    DELETED: 'deleted'
};
const TASK_FREQUENCY_ACCEPTED_UNITS = {
    MINUTE: 'minute',
    MINUTES: 'minutes',
    HOUR: 'hour',
    HOURS: 'hours',
    DAY: 'day',
    DAYS: 'days'
};
const TASK_FREQUENCY_ACCEPTED_UNITS_TO_VALUE = {
    [TASK_FREQUENCY_ACCEPTED_UNITS.MINUTE]: 'minute',
    [TASK_FREQUENCY_ACCEPTED_UNITS.MINUTES]: 'minute',
    [TASK_FREQUENCY_ACCEPTED_UNITS.HOUR]: 'hour',
    [TASK_FREQUENCY_ACCEPTED_UNITS.HOURS]: 'hour',
    [TASK_FREQUENCY_ACCEPTED_UNITS.DAY]: 'day',
    [TASK_FREQUENCY_ACCEPTED_UNITS.DAYS]: 'day'
};
const TASK_FREQUENCY_UNIT = {
    MINUTE: 'minute',
    HOUR: 'hour',
    DAY: 'day'
};
const TASK_FREQUENCY_UNIT_LABELS = {
    [TASK_FREQUENCY_UNIT.MINUTE]: 'minute (s)',
    [TASK_FREQUENCY_UNIT.HOUR]: 'hour (s)',
    [TASK_FREQUENCY_UNIT.DAY]: 'day (s)'
};
const TASK_DURATION_UNIT = {
    HOURS: 'hours',
    DAYS: 'days',
    OCCURRENCES: 'occurrences'
};
const TASK_DURATION_UNIT_LABELS = {
    [TASK_DURATION_UNIT.HOURS]: 'hour (s)',
    [TASK_DURATION_UNIT.DAYS]: 'day (s)',
    [TASK_DURATION_UNIT.OCCURRENCES]: 'occurrence (s)'
};
const TASK_NOTE_COMPLETE_OVERDUE_REASON_ID = 'tasknotcompletedreason-taskoverdue';
const TASK_DELETE_BY_SYSTEM_REASON = 'taskdeletionreason-deletedbysystem';
const TASK_DELETE_RECORDED_IN_ERROR_REASON_ID = 'taskdeletionreason-recordedinerror';
const TASK_DELETE_PATIENT_DISCHARGED_REASON_ID = 'taskdeletionreason-patientdischarged';

//# sourceMappingURL=tasks.js.map