"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.sequelize.query(`
    ALTER TABLE patient_field_values DROP CONSTRAINT patient_field_values_pkey;
    ALTER TABLE patient_field_values ADD PRIMARY KEY (patient_id, definition_id);
  `);
    await query.removeColumn('patient_field_values', 'id');
    await query.addColumn('patient_field_values', 'id', {
        type: `TEXT GENERATED ALWAYS AS (REPLACE("patient_id", ';', ':') || ';' || REPLACE("definition_id", ';', ':')) STORED`
    });
}
async function down(query) {
    await query.removeColumn('patient_field_values', 'id');
    await query.addColumn('patient_field_values', 'id', {
        type: _sequelize.default.TEXT,
        allowNull: false,
        defaultValue: _sequelize.default.fn('uuid_generate_v4')
    });
    await query.sequelize.query(`
    ALTER TABLE patient_field_values DROP CONSTRAINT patient_field_values_pkey;
    ALTER TABLE patient_field_values ADD PRIMARY KEY (id);
  `);
}

//# sourceMappingURL=1670446124209-useGeneratedPatientFieldValueId.js.map