import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class DocumentMetadata extends Model {
    id: string;
    name: string;
    type: string;
    source: string;
    documentCreatedAt?: string;
    documentUploadedAt: string;
    documentOwner?: string;
    note?: string;
    attachmentId: string;
    encounterId?: string;
    patientId?: string;
    departmentId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
}
//# sourceMappingURL=DocumentMetadata.d.ts.map