"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterDiagnosis", {
    enumerable: true,
    get: function() {
        return EncounterDiagnosis;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildEncounterLinkedLookupFilter = require("../sync/buildEncounterLinkedLookupFilter");
const _model = require("../types/model");
let EncounterDiagnosis = class EncounterDiagnosis extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            certainty: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: _constants.DIAGNOSIS_CERTAINTY.SUSPECTED,
                validate: {
                    isIn: [
                        _constants.DIAGNOSIS_CERTAINTY_VALUES
                    ]
                }
            },
            isPrimary: _sequelize.DataTypes.BOOLEAN,
            date: (0, _model.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            })
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL,
            validate: {
                mustHaveDiagnosis () {
                    if (!this.diagnosisId) {
                        throw new Error('An encounter diagnosis must be attached to a diagnosis.');
                    }
                },
                mustHaveEncounter () {
                    if (!this.encounterId) {
                        throw new Error('An encounter diagnosis must be attached to an encounter.');
                    }
                }
            }
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Encounter, {
            foreignKey: 'encounterId',
            as: 'encounter'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'diagnosisId',
            as: 'Diagnosis'
        });
        this.belongsTo(models.User, {
            foreignKey: 'clinicianId',
            as: 'clinician'
        });
    }
    static getListReferenceAssociations() {
        return [
            'Diagnosis'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildEncounterLinkedLookupFilter.buildEncounterLinkedLookupFilter)(this);
    }
};

//# sourceMappingURL=EncounterDiagnosis.js.map