"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceInsurerPayment", {
    enumerable: true,
    get: function() {
        return InvoiceInsurerPayment;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _buildEncounterLinkedSyncFilter = require("../sync/buildEncounterLinkedSyncFilter");
const _buildSyncLookupSelect = require("../sync/buildSyncLookupSelect");
let InvoiceInsurerPayment = class InvoiceInsurerPayment extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            insurerId: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            status: {
                type: _sequelize.DataTypes.STRING,
                allowNull: false
            },
            reason: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoicePayment, {
            foreignKey: 'invoicePaymentId',
            as: 'detail'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'insurerId',
            as: 'insurer',
            constraints: false
        });
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilter)([
            this.tableName,
            'invoice_payments',
            'invoices',
            'encounters'
        ], markedForSyncPatientsTable);
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _buildSyncLookupSelect.buildSyncLookupSelect)(this, {
                patientId: 'encounters.patient_id'
            }),
            joins: (0, _buildEncounterLinkedSyncFilter.buildEncounterLinkedSyncFilterJoins)([
                this.tableName,
                'invoice_payments',
                'invoices',
                'encounters'
            ])
        };
    }
    static getFullReferenceAssociations() {
        return [
            {
                model: this.sequelize.models.InvoicePayment,
                as: 'detail'
            }
        ];
    }
    static getListReferenceAssociations(models) {
        return [
            {
                model: models.ReferenceData,
                as: 'insurer'
            }
        ];
    }
};

//# sourceMappingURL=InvoiceInsurerPayment.js.map