"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ProgramRegistryClinicalStatus", {
    enumerable: true,
    get: function() {
        return ProgramRegistryClinicalStatus;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let ProgramRegistryClinicalStatus = class ProgramRegistryClinicalStatus extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false,
                unique: true
            },
            name: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            color: _sequelize.DataTypes.TEXT,
            visibilityStatus: {
                type: _sequelize.DataTypes.TEXT,
                defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ProgramRegistry, {
            foreignKey: {
                name: 'programRegistryId',
                allowNull: false
            },
            as: 'programRegistry'
        });
        this.hasMany(models.PatientProgramRegistration, {
            foreignKey: 'clinicalStatusId',
            as: 'patientProgramRegistrations'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ProgramRegistryClinicalStatus.js.map