"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TaskTemplate", {
    enumerable: true,
    get: function() {
        return TaskTemplate;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let TaskTemplate = class TaskTemplate extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            referenceDataId: {
                type: _sequelize.DataTypes.INTEGER,
                allowNull: false,
                unique: true,
                references: {
                    model: 'referenceData',
                    key: 'id'
                }
            },
            frequencyValue: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            },
            frequencyUnit: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            },
            highPriority: {
                type: _sequelize.DataTypes.BOOLEAN,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'referenceDataId',
            as: 'referenceData'
        });
        this.hasMany(models.TaskTemplateDesignation, {
            foreignKey: 'taskTemplateId',
            as: 'designations'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
    static getFullReferenceAssociations() {
        const { models } = this.sequelize;
        return [
            'referenceData',
            {
                model: models.TaskTemplateDesignation,
                as: 'designations',
                include: [
                    {
                        model: models.ReferenceData,
                        as: 'designation',
                        attributes: [
                            'name'
                        ]
                    }
                ]
            }
        ];
    }
};

//# sourceMappingURL=TaskTemplate.js.map