"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "bumpSyncTickForRepull", {
    enumerable: true,
    get: function() {
        return bumpSyncTickForRepull;
    }
});
const _lodash = require("lodash");
const _constants = require("./constants");
const _findSyncSnapshotRecords = require("./findSyncSnapshotRecords");
const bumpSyncTickForRepull = async (sequelize, persistedModels, sessionId)=>{
    // No need to load records in batches for memory issue as
    // the number of records that require repull should be small
    const records = await (0, _findSyncSnapshotRecords.findSyncSnapshotRecords)(sequelize, sessionId, _constants.SYNC_SESSION_DIRECTION.INCOMING, undefined, undefined, undefined, 'requires_repull IS TRUE');
    const recordsByType = (0, _lodash.groupBy)(records, 'recordType');
    for (const [recordType, records] of Object.entries(recordsByType)){
        const typedRecords = records;
        const model = Object.values(persistedModels).find((model)=>model.tableName === recordType);
        await model?.sequelize.query(`
        UPDATE ${model.tableName}
        SET updated_at_sync_tick = 1
        WHERE id IN (:ids)
        RETURNING id;
      `, {
            replacements: {
                ids: typedRecords.map((r)=>r.recordId)
            }
        });
    }
};

//# sourceMappingURL=bumpSyncTickForRepull.js.map