import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import type { ReferenceData } from './ReferenceData';
import type { LabTestType } from './LabTestType';
export declare class InvoiceProduct extends Model {
    id: string;
    name: string;
    price: number;
    discountable: boolean;
    visibilityStatus: string;
    referenceData?: ReferenceData;
    labTestType?: LabTestType;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
    static getFullReferenceAssociations(): string[];
    addVirtualFields(): this;
}
//# sourceMappingURL=InvoiceProduct.d.ts.map