import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
/** Holds a record of a lab request's status at a specific point in time */
export declare class LabRequestLog extends Model {
    id: string;
    status?: string;
    labRequestId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static getListReferenceAssociations(): string[];
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
}
//# sourceMappingURL=LabRequestLog.d.ts.map