import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS, VISIBILITY_STATUSES } from '@tamanu/constants';
import { InvalidOperationError } from '@tamanu/shared/errors';
import { Model } from './Model';
export class LocationGroup extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            code: {
                type: DataTypes.STRING,
                allowNull: false
            },
            name: {
                type: DataTypes.STRING,
                allowNull: false
            },
            visibilityStatus: {
                type: DataTypes.TEXT,
                defaultValue: VISIBILITY_STATUSES.CURRENT
            },
            isBookable: {
                type: DataTypes.BOOLEAN,
                defaultValue: false
            }
        }, {
            ...options,
            validate: {
                mustHaveFacility () {
                    if (!this.deletedAt && !this.facilityId) {
                        throw new InvalidOperationError('A location group must have a facility.');
                    }
                },
                mustNotIncludeComma () {
                    if (this.name.includes(',')) {
                        throw new InvalidOperationError('A location group name cannot include a comma.');
                    }
                }
            },
            syncDirection: SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    unique: true,
                    fields: [
                        'code'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Facility, {
            foreignKey: 'facilityId',
            as: 'facility'
        });
        this.hasMany(models.Location, {
            foreignKey: 'locationGroupId'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
}

//# sourceMappingURL=LocationGroup.js.map