import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class PatientProgramRegistration extends Model {
    id: string;
    date: string;
    registrationStatus: string;
    isMostRecent: boolean;
    patientId: string;
    programRegistryId: string;
    clinicalStatusId?: string;
    clinicianId?: string;
    registeringFacilityId?: string;
    facilityId?: string;
    villageId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static getFullReferenceAssociations(): string[];
    static getListReferenceAssociations(): string[];
    static initRelations(models: Models): void;
    static create(values: any): Promise<any>;
    static getMostRecentRegistrationsForPatient(patientId: string): Promise<PatientProgramRegistration[]>;
    static buildSyncFilter(): null;
    static buildSyncLookupQueryDetails(): null;
}
//# sourceMappingURL=PatientProgramRegistration.d.ts.map