"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    SettingsCache: function() {
        return SettingsCache;
    },
    settingsCache: function() {
        return settingsCache;
    }
});
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let SettingsCache = class SettingsCache {
    getAllSettings() {
        // If cache is expired, reset it.
        if (!this.isValid()) {
            this.reset();
        }
        return this.allSettingsCache;
    }
    getFrontEndSettings() {
        if (!this.isValid()) {
            this.reset();
        }
        return this.frontEndSettingsCache;
    }
    setAllSettings(value) {
        this.allSettingsCache = value;
        // Calculate expiration timestamp based on ttl
        this.expirationTimestamp = Date.now() + this.ttl;
    }
    setFrontEndSettings(value) {
        this.frontEndSettingsCache = value;
        this.expirationTimestamp = Date.now() + this.ttl;
    }
    reset() {
        this.allSettingsCache = null;
        this.frontEndSettingsCache = null;
        this.expirationTimestamp = null;
    }
    isValid() {
        return this.expirationTimestamp && Date.now() < this.expirationTimestamp;
    }
    constructor(){
        _define_property(this, "allSettingsCache", null);
        _define_property(this, "frontEndSettingsCache", null);
        _define_property(this, "expirationTimestamp", null);
        // TTL in milliseconds
        _define_property(this, "ttl", 60000);
    }
};
const settingsCache = new SettingsCache();

//# sourceMappingURL=settingsCache.js.map