"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "checkReportModulePermissions", {
    enumerable: true,
    get: function() {
        return checkReportModulePermissions;
    }
});
const _errors = require("../../errors");
const _canRunStaticReport = require("./canRunStaticReport");
const _reportDefinitions = require("../reportDefinitions");
const _canRunSurveyReport = require("./canRunSurveyReport");
async function checkReportModulePermissions(req, reportModule, reportId, parameters) {
    const { ReportDefinitionVersion } = req.models;
    if (reportModule instanceof ReportDefinitionVersion) {
        const definition = await reportModule.getReportDefinition();
        req.checkPermission('run', definition);
    } else {
        if (!(0, _canRunStaticReport.canRunStaticReport)(req.ability, reportId)) {
            throw new _errors.ForbiddenError('User does not have permission to run the report');
        }
    }
    // Special case to check if user can run survey report
    if (reportId === _reportDefinitions.GENERIC_SURVEY_EXPORT_REPORT_ID) {
        if (!(0, _canRunSurveyReport.canRunSurveyReport)(req.ability, parameters?.surveyId)) {
            throw new _errors.ForbiddenError('User does not have permission to run the report');
        }
    }
    req.flagPermissionChecked();
}

//# sourceMappingURL=checkReportModulePermissions.js.map