"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientDetailsWithAddress", {
    enumerable: true,
    get: function() {
        return PatientDetailsWithAddress;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataSection = require("./DataSection");
const _Layout = require("../Layout");
const _patientAccessors = require("../../patientAccessors");
const _languageContext = require("../../pdf/languageContext");
const _renderDataItems = require("./renderDataItems");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const PATIENT_FIELDS = {
    leftCol: [
        {
            key: 'firstName',
            label: 'First Name'
        },
        {
            key: 'lastName',
            label: 'Last Name'
        },
        {
            key: 'dateOfBirth',
            label: 'DOB',
            accessor: _patientAccessors.getDobWithAge
        },
        {
            key: 'address',
            label: 'Address',
            accessor: _patientAccessors.getAddress
        }
    ],
    rightCol: [
        {
            key: 'displayId',
            label: 'Patient ID'
        },
        {
            key: 'sex',
            label: 'Sex',
            accessor: _patientAccessors.getSex
        },
        {
            key: 'villageId',
            label: 'Village',
            accessor: _patientAccessors.getVillageName
        }
    ]
};
const PatientDetailsWithAddress = ({ patient, getLocalisation })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: getTranslation('pdf.patientDetails.title', 'Patient details')
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.leftCol, patient, getLocalisation, getTranslation)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_FIELDS.rightCol, patient, getLocalisation, getTranslation)));
};

//# sourceMappingURL=PatientDetailsWithAddress.js.map