"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SurveyResponseDetails", {
    enumerable: true,
    get: function() {
        return SurveyResponseDetails;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataSection = require("./DataSection");
const _DataItem = require("./DataItem");
const _Layout = require("../Layout");
const _dateTime = require("@tamanu/utils/dateTime");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const SurveyResponseDetails = ({ surveyResponse })=>{
    return /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        hideTopRule: true,
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Clinician",
        value: surveyResponse.submittedBy
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Date of submission",
        value: (0, _dateTime.formatShort)(surveyResponse.endTime)
    })));
};

//# sourceMappingURL=SurveyResponseDetails.js.map