"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHoneycombMetricReader = exports.getHoneycombMetricExporter = exports.getHoneycombSpanExporter = exports.OTLP_PROTO_VERSION = exports.OTLP_HEADER_KEY = exports.DATASET_HEADER_KEY = exports.TEAM_HEADER_KEY = void 0;
const sdk_metrics_1 = require("@opentelemetry/sdk-metrics");
const grpc_metric_exporter_1 = require("./grpc-metric-exporter");
const grpc_trace_exporter_1 = require("./grpc-trace-exporter");
const honeycomb_options_1 = require("./honeycomb-options");
const http_proto_metric_exporter_1 = require("./http-proto-metric-exporter");
const http_proto_trace_exporter_1 = require("./http-proto-trace-exporter");
exports.TEAM_HEADER_KEY = 'x-honeycomb-team';
exports.DATASET_HEADER_KEY = 'x-honeycomb-dataset';
exports.OTLP_HEADER_KEY = 'x-otlp-version';
exports.OTLP_PROTO_VERSION = '0.16.0';
/**
 * Configures and returns a {@link SpanExporter} based on the OTLP protocol
 * provided via options.
 *
 * Defaults to a http/protobuf exporter if not configured.
 *
 * @param options the {@link HoneycombOptions} used to configure the exporter
 * @returns a {@link SpanExporter} configured to send telemetry to Honeycomb
 */
function getHoneycombSpanExporter(options) {
    if ((options === null || options === void 0 ? void 0 : options.protocol) == honeycomb_options_1.OtlpProtocolKind.Grpc) {
        return (0, grpc_trace_exporter_1.configureHoneycombGrpcTraceExporter)(options);
    }
    return (0, http_proto_trace_exporter_1.configureHoneycombHttpProtoTraceExporter)(options);
}
exports.getHoneycombSpanExporter = getHoneycombSpanExporter;
/**
 * Configures and returns a metric exporter based on the OTLP protocol
 * provided via options.
 *
 * Defaults to a http/protobuf exporter if not configured.
 *
 * @param options the {@link HoneycombOptions} used to configure the exporter
 * @returns a metrics exporter configured to send telemetry to Honeycomb
 */
function getHoneycombMetricExporter(options) {
    if ((options === null || options === void 0 ? void 0 : options.protocol) == honeycomb_options_1.OtlpProtocolKind.Grpc) {
        return (0, grpc_metric_exporter_1.configureHoneycombGrpcMetricExporter)(options);
    }
    return (0, http_proto_metric_exporter_1.configureHoneycombHttpProtoMetricExporter)(options);
}
exports.getHoneycombMetricExporter = getHoneycombMetricExporter;
/**
 * Builds and returns an OTLP Metric reader that configures a metric exporter to send data over http/protobuf periodically
 * @param options The {@link HoneycombOptions} used to configure the exporter
 * @returns a {@link PeriodicExportingMetricReader} configured to send telemetry to Honeycomb over http/protobuf
 */
function getHoneycombMetricReader(options) {
    if (!(options === null || options === void 0 ? void 0 : options.metricsDataset)) {
        // only enable metrics if a metrics dataset has been set
        return undefined;
    }
    return new sdk_metrics_1.PeriodicExportingMetricReader({
        exporter: getHoneycombMetricExporter(options),
        exportIntervalMillis: (0, honeycomb_options_1.getMetricsInterval)(),
        exportTimeoutMillis: (0, honeycomb_options_1.getMetricsTimeout)(),
    });
}
exports.getHoneycombMetricReader = getHoneycombMetricReader;
