"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        // Default to true for existing records
        await query.addColumn('administered_vaccines', 'consent', {
            type: Sequelize.BOOLEAN,
            allowNull: true,
            defaultValue: true
        });
        // Update default to null for future records
        await query.changeColumn('administered_vaccines', 'consent', {
            type: Sequelize.BOOLEAN,
            allowNull: true,
            defaultValue: null
        });
    },
    down: async (query)=>{
        await query.removeColumn('administered_vaccines', 'consent');
    }
};

//# sourceMappingURL=068_addVaccineConsentField.js.map