"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_default(require("sequelize"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function up(query) {
    await query.addColumn('administered_vaccines', 'marked_for_push', {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: true
    });
    await query.addColumn('administered_vaccines', 'is_pushing', {
        type: _sequelize.default.BOOLEAN,
        allowNull: false,
        defaultValue: false
    });
    await query.addColumn('administered_vaccines', 'pushed_at', {
        type: _sequelize.default.DATE,
        allowNull: true
    });
    await query.addColumn('administered_vaccines', 'pulled_at', {
        type: _sequelize.default.DATE,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn('administered_vaccines', 'marked_for_push');
    await query.removeColumn('administered_vaccines', 'is_pushing');
    await query.removeColumn('administered_vaccines', 'pushed_at');
    await query.removeColumn('administered_vaccines', 'pulled_at');
}

//# sourceMappingURL=098_addSyncColumnsAdministeredVaccine.js.map