"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const TABLE = {
    schema: 'fhir',
    tableName: 'service_requests'
};
async function up(query) {
    await query.addColumn(TABLE, 'contained', {
        type: _sequelize.DataTypes.JSONB,
        allowNull: true
    });
    await query.addColumn(TABLE, 'encounter', {
        type: _sequelize.DataTypes.JSONB,
        allowNull: true
    });
    await query.addColumn(TABLE, 'note', {
        type: _sequelize.DataTypes.JSONB,
        allowNull: true
    });
}
async function down(query) {
    await query.removeColumn(TABLE, 'contained');
    await query.removeColumn(TABLE, 'encounter');
    await query.removeColumn(TABLE, 'note');
}

//# sourceMappingURL=1681331866447-addMoreFieldsToFhirServiceRequest.js.map