"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Asset", {
    enumerable: true,
    get: function() {
        return Asset;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
let Asset = class Asset extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            name: _sequelize.DataTypes.STRING,
            type: _sequelize.DataTypes.STRING,
            data: _sequelize.DataTypes.BLOB
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    /**
   * This is only used when inserting asset manually through RestClient
   * Asset is PULL_FROM_CENTRAL, i.e. we don't sync asset up from devices to sync servers.
   */ static sanitizeForCentralServer({ data, ...restOfValues }) {
        // Postgres-format hex string of binary data
        if (typeof data === 'string' && data.substring(0, 2) === '\\x') {
            return {
                ...restOfValues,
                data: Buffer.from(data.substring(2), 'hex')
            };
        }
        // Other strings: assume base64
        if (typeof data === 'string') {
            return {
                ...restOfValues,
                data: Buffer.from(data, 'base64')
            };
        }
        return {
            ...restOfValues,
            data: Buffer.from(data)
        };
    }
    static sanitizeForFacilityServer({ data, ...restOfValues }) {
        // Postgres-format hex string of binary data
        if (typeof data === 'string' && data.substring(0, 2) === '\\x') {
            return {
                ...restOfValues,
                data: Buffer.from(data.substring(2), 'hex')
            };
        }
        // Anything else that Buffer natively supports
        return {
            ...restOfValues,
            data: Buffer.from(data)
        };
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=Asset.js.map