"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientCondition", {
    enumerable: true,
    get: function() {
        return PatientCondition;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _buildPatientSyncFilterViaPatientId = require("../sync/buildPatientSyncFilterViaPatientId");
const _buildPatientLinkedLookupFilter = require("../sync/buildPatientLinkedLookupFilter");
const _model = require("../types/model");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let PatientCondition = class PatientCondition extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            note: _sequelize.DataTypes.STRING,
            recordedDate: (0, _model.dateTimeType)('recordedDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: false
            }),
            resolved: {
                type: _sequelize.DataTypes.BOOLEAN,
                defaultValue: false
            },
            resolutionDate: (0, _model.dateTimeType)('resolutionDate', {
                defaultValue: _dateTime.getCurrentDateTimeString,
                allowNull: true
            }),
            resolutionNote: _sequelize.DataTypes.TEXT
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId'
        });
        this.belongsTo(models.ReferenceData, {
            foreignKey: 'conditionId',
            as: 'condition'
        });
        this.belongsTo(models.User, {
            foreignKey: 'examinerId'
        });
        this.belongsTo(models.User, {
            foreignKey: 'resolutionPractitionerId'
        });
    }
    static getListReferenceAssociations() {
        return [
            'condition'
        ];
    }
    static buildSyncLookupQueryDetails() {
        return (0, _buildPatientLinkedLookupFilter.buildPatientLinkedLookupFilter)(this);
    }
};
_define_property(PatientCondition, "buildPatientSyncFilter", _buildPatientSyncFilterViaPatientId.buildPatientSyncFilterViaPatientId);

//# sourceMappingURL=PatientCondition.js.map