import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class SurveyResponse extends Model {
    id: string;
    startTime?: string;
    endTime?: string;
    result?: number;
    resultText?: string;
    notified?: boolean;
    metadata?: Record<string, any>;
    userId?: string;
    surveyId?: string;
    encounterId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
    static getSurveyEncounter({ encounterId, patientId, forceNewEncounter, reasonForEncounter, ...responseData }: {
        encounterId: string | null;
        patientId: string;
        forceNewEncounter: boolean;
        reasonForEncounter: string;
        [key: string]: any;
    }): Promise<any>;
    static createWithAnswers(data: {
        answers: any[];
        surveyId: string;
        patientId: string;
        encounterId: string | null;
        forceNewEncounter: boolean;
        facilityId: string;
        [key: string]: any;
    }): Promise<SurveyResponse>;
}
//# sourceMappingURL=SurveyResponse.d.ts.map