"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, // eslint-disable-next-line no-unused-vars
"default", {
    enumerable: true,
    get: function() {
        return errorHandler;
    }
});
const _errors = require("@tamanu/shared/errors");
const _logging = require("@tamanu/shared/services/logging");
function errorHandler(error, req, res, _) {
    const code = (0, _errors.getCodeForErrorName)(error.name);
    if (error.name === 'BadAuthenticationError') {
        _logging.log.warn(`Error ${code}: ${error.message}`);
    } else if (code >= 500) {
        _logging.log.error(`Error ${code}: `, error);
    } else {
        _logging.log.info(`Error ${code}: `, error);
    }
    // we're past the point of permission checking; this just
    // makes sure the error send doesn't get intercepted by the
    // permissions middleware
    if (req.flagPermissionChecked) {
        req.flagPermissionChecked();
    }
    res.status(code).send({
        error: {
            message: error.message,
            ...error
        }
    });
}

//# sourceMappingURL=errorHandler.js.map