"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    startTasks: function() {
        return startTasks;
    },
    startTasksCommand: function() {
        return startTasksCommand;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _timeZoneCheck = require("@tamanu/shared/utils/timeZoneCheck");
const _selectFacilityIds = require("@tamanu/utils/selectFacilityIds");
const _checkConfig = require("../checkConfig");
const _initDeviceId = require("../sync/initDeviceId");
const _initTimesync = require("../services/initTimesync");
const _database = require("../database");
const _sync = require("../sync");
const _tasks = require("../tasks");
const _serverInfo = require("../serverInfo");
const _ApplicationContext = require("../ApplicationContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function startTasks({ skipMigrationCheck, taskClasses, syncManager }) {
    _logging.log.info(`Starting facility task runner version ${_serverInfo.version}`, {
        serverFacilityIds: (0, _selectFacilityIds.selectFacilityIds)(_config.default)
    });
    _logging.log.info(`Process info`, {
        execArgs: process.execArgs || '<empty>'
    });
    const context = await new _ApplicationContext.ApplicationContext().init({
        appType: 'tasks'
    });
    if (_config.default.db.migrateOnStartup) {
        await context.sequelize.migrate('up');
    } else {
        await context.sequelize.assertUpToDate({
            skipMigrationCheck
        });
    }
    await (0, _initDeviceId.initDeviceId)(context);
    await (0, _checkConfig.checkConfig)(context);
    await (0, _database.performDatabaseIntegrityChecks)(context);
    context.timesync = await (0, _initTimesync.initTimesync)({
        models: context.models,
        url: `${_config.default.sync.host.trim().replace(/\/*$/, '')}/api/timesync`
    });
    context.centralServer = new _sync.CentralServerConnection(context);
    context.syncManager = syncManager ?? new _sync.FacilitySyncManager(context);
    await (0, _timeZoneCheck.performTimeZoneChecks)({
        remote: context.centralServer,
        sequelize: context.sequelize,
        config: _config.default
    });
    const cancelTasks = (0, _tasks.startScheduledTasks)(context, taskClasses);
    process.once('SIGTERM', ()=>{
        _logging.log.info('Received SIGTERM, stopping scheduled tasks');
        cancelTasks();
    });
}
const startTasksCommand = new _commander.Command('startTasks').description('Start the Tamanu Facility tasks runner').option('--skipMigrationCheck', 'skip the migration check on startup').action(startTasks);

//# sourceMappingURL=startTasks.js.map