"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FacilitySyncConnection", {
    enumerable: true,
    get: function() {
        return FacilitySyncConnection;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _errors = require("@tamanu/shared/errors");
const _utils = require("@tamanu/shared/utils");
const _logging = require("@tamanu/shared/services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let FacilitySyncConnection = class FacilitySyncConnection {
    async fetch(endpoint, params = {}) {
        const { body, method = 'GET' } = params;
        const url = `${this.host}/sync/${endpoint}`;
        _logging.log.debug(`[FacilitySyncConnection] ${method} ${url}`);
        const response = await fetch(url, {
            method,
            headers: {
                Accept: 'application/json',
                'Content-Type': body ? 'application/json' : undefined
            },
            body: body && JSON.stringify(body)
        });
        if (!response.ok) {
            const responseBody = await (0, _utils.getResponseJsonSafely)(response);
            const { error } = responseBody;
            const errorMessage = error ? error.message : 'no error message given';
            const err = new _errors.RemoteCallFailedError(`Faciliy Sync API responded with status code ${response.status} (${errorMessage})`);
            throw err;
        }
        return response.json();
    }
    async runSync(syncData) {
        return this.fetch('run', {
            method: 'POST',
            body: {
                syncData
            }
        });
    }
    async getSyncStatus() {
        return this.fetch('status');
    }
    constructor(){
        this.host = `${_config.default.sync.syncApiConnection.host.trim().replace(/\/*$/, '')}:${_config.default.sync.syncApiConnection.port}`;
    }
};

//# sourceMappingURL=FacilitySyncConnection.js.map