"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    BadAuthenticationError: function() {
        return BadAuthenticationError;
    },
    FacilityAndSyncVersionIncompatibleError: function() {
        return FacilityAndSyncVersionIncompatibleError;
    },
    ForbiddenError: function() {
        return ForbiddenError;
    },
    InappropriateEndpointError: function() {
        return InappropriateEndpointError;
    },
    InsufficientStorageError: function() {
        return InsufficientStorageError;
    },
    InvalidClientHeadersError: function() {
        return InvalidClientHeadersError;
    },
    InvalidConfigError: function() {
        return InvalidConfigError;
    },
    InvalidOperationError: function() {
        return InvalidOperationError;
    },
    InvalidParameterError: function() {
        return InvalidParameterError;
    },
    NotFoundError: function() {
        return NotFoundError;
    },
    RemoteCallFailedError: function() {
        return RemoteCallFailedError;
    },
    RemoteTimeoutError: function() {
        return RemoteTimeoutError;
    },
    RequestQueueExceededError: function() {
        return RequestQueueExceededError;
    },
    RequestQueueTimeoutError: function() {
        return RequestQueueTimeoutError;
    },
    ResourceConflictError: function() {
        return ResourceConflictError;
    },
    ValidationError: function() {
        return ValidationError;
    },
    getCodeForErrorName: function() {
        return getCodeForErrorName;
    }
});
let BaseError = class BaseError extends Error {
    constructor(message){
        super(message);
        this.name = this.constructor.name;
        this.status = getCodeForErrorName(this.name);
    }
};
let NotFoundError = class NotFoundError extends BaseError {
};
let BadAuthenticationError = class BadAuthenticationError extends BaseError {
};
let ForbiddenError = class ForbiddenError extends BaseError {
};
let InvalidOperationError = class InvalidOperationError extends BaseError {
};
let InvalidParameterError = class InvalidParameterError extends BaseError {
};
let InappropriateEndpointError = class InappropriateEndpointError extends BaseError {
};
let RemoteTimeoutError = class RemoteTimeoutError extends BaseError {
};
let RemoteCallFailedError = class RemoteCallFailedError extends BaseError {
};
let RequestQueueTimeoutError = class RequestQueueTimeoutError extends BaseError {
};
let RequestQueueExceededError = class RequestQueueExceededError extends BaseError {
};
let InsufficientStorageError = class InsufficientStorageError extends BaseError {
};
let InvalidClientHeadersError = class InvalidClientHeadersError extends BaseError {
};
let InvalidConfigError = class InvalidConfigError extends BaseError {
};
let FacilityAndSyncVersionIncompatibleError = class FacilityAndSyncVersionIncompatibleError extends BaseError {
};
let ValidationError = class ValidationError extends BaseError {
};
let ResourceConflictError = class ResourceConflictError extends BaseError {
};
function getCodeForErrorName(name) {
    switch(name){
        case 'InvalidClientHeadersError':
            return 400;
        case 'BadAuthenticationError':
            return 401;
        case 'ForbiddenError':
            return 403;
        case 'NotFoundError':
            return 404;
        case 'InappropriateEndpointError':
            // method not allowed - usually for PUTting an endpoint that expects POST
            // but it's the closest status code we have without getting in to redirects
            return 405;
        case 'ResourceConflictError':
            // trying to create/update a record with a data conflict
            return 409;
        case 'SequelizeUniqueConstraintError':
        case 'SequelizeValidationError':
        case 'SequelizeForeignKeyConstraintError':
        case 'InvalidOperationError':
        case 'InvalidParameterError':
        case 'ValidationError':
            // unprocessable entity - syntax is correct but data is bad
            return 422;
        case 'RemoteCallFailedError':
        case 'FacilityAndSyncVersionIncompatibleError':
            // remote server returned an error
            return 502;
        case 'RemoteTimeoutError':
            // remote server timed out
            return 504;
        case 'RequestQueueTimeoutError':
        case 'RequestQueueExceededError':
            // load shedder kicked in
            return 503;
        case 'InsufficientStorageError':
            return 507;
        default:
            // error isn't otherwise caught - this is a problem with the server
            return 500;
    }
}

//# sourceMappingURL=errors.js.map