"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLabTestsFromLabRequests", {
    enumerable: true,
    get: function() {
        return getLabTestsFromLabRequests;
    }
});
const getLabTestsFromLabRequests = async (labRequests)=>{
    const labTests = labRequests.map((labRequest)=>{
        const { tests, ...labRequestData } = labRequest;
        return {
            ...labRequestData,
            ...tests
        };
    });
    return labTests.sort((a, b)=>Date.parse(b.date) - Date.parse(a.date));
};

//# sourceMappingURL=getLabTestsFromLabRequests.js.map