"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "VaccineCertificate", {
    enumerable: true,
    get: function() {
        return VaccineCertificate;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Table = require("./Table");
const _Layout = require("./Layout");
const _PatientDetailsSection = require("./PatientDetailsSection");
const _Typography = require("./Typography");
const _LetterheadSection = require("./LetterheadSection");
const _getDisplayDate = require("./getDisplayDate");
const _SigningSection = require("./SigningSection");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _lodash = require("lodash");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const columns = (getTranslation)=>[
        {
            key: 'date',
            title: getTranslation('pdf.table.column.dateGiven', 'Date given'),
            accessor: ({ date }, getLocalisation)=>date ? (0, _getDisplayDate.getDisplayDate)(date, undefined, getLocalisation) : 'Unknown'
        },
        {
            key: 'schedule',
            title: getTranslation('pdf.table.column.schedule', 'Schedule'),
            accessor: ({ scheduledVaccine })=>(scheduledVaccine || {}).doseLabel
        },
        {
            key: 'vaccine',
            title: getTranslation('pdf.table.column.vaccine', 'Vaccine'),
            customStyles: {
                minWidth: 30
            },
            accessor: ({ scheduledVaccine, vaccineName })=>vaccineName || (scheduledVaccine || {}).label
        },
        {
            key: 'vaccineBrand',
            title: getTranslation('pdf.table.column.vaccineBrand', 'Vaccine brand'),
            customStyles: {
                minWidth: 30
            },
            accessor: ({ scheduledVaccine, vaccineBrand })=>vaccineBrand || ((scheduledVaccine || {}).vaccine || {}).name
        },
        {
            key: 'countryName',
            title: getTranslation('pdf.table.column.country', 'Facility/Country'),
            accessor: (record)=>{
                const facility = record.givenElsewhere ? record.givenBy : record.location?.facility?.name;
                return facility || '';
            }
        }
    ];
const vaccineCertificateStyles = _renderer.StyleSheet.create({
    footerContent: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        alignItems: 'center'
    },
    footerLeft: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    footerRight: {
        flex: 1,
        textAlign: 'right'
    },
    labelText: {
        fontSize: 8,
        fontFamily: 'Helvetica-Bold',
        fontWeight: 400,
        color: '#888888'
    },
    valueText: {
        fontSize: 8,
        fontWeight: 400,
        color: '#888888',
        fontFamily: 'Helvetica'
    },
    documentHeaderContent: {
        flexDirection: 'row'
    }
});
const VaccineCertificateHeader = ({ patient })=>{
    const valueStyles = (0, _MultiPageHeader.useTextStyles)(vaccineCertificateStyles.valueText);
    const labelStyles = (0, _MultiPageHeader.useTextStyles)(vaccineCertificateStyles.labelText);
    const ValueText = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.Text, {
            style: valueStyles,
            ...props
        });
    const LabelText = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.Text, {
            style: labelStyles,
            ...props
        });
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        render: ({ pageNumber })=>pageNumber > 1 && /*#__PURE__*/ _react.default.createElement(_renderer.View, {
                style: vaccineCertificateStyles.documentHeaderContent
            }, /*#__PURE__*/ _react.default.createElement(ValueText, null, getTranslation('pdf.vaccineCertificate.immunisationCertificate', 'Immunisation Certificate'), ' ', "|", ' '), /*#__PURE__*/ _react.default.createElement(LabelText, null, getTranslation('pdf.vaccineCertificate.patientName', 'Patient name'), ":", ' '), /*#__PURE__*/ _react.default.createElement(ValueText, null, patient.firstName, " ", patient.lastName, " |", ' '), /*#__PURE__*/ _react.default.createElement(LabelText, null, getTranslation('pdf.vaccineCertificate.patientId', 'Patient ID'), ":", ' '), /*#__PURE__*/ _react.default.createElement(ValueText, null, patient.displayId))
    });
};
const VaccineCertificateComponent = ({ patient, printedBy, printedDate, facilityName, vaccinations, certificateId, watermarkSrc, signingSrc, logoSrc, localisation, settings, extraPatientFields, certificateData, healthFacility })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const getLocalisation = (key)=>(0, _lodash.get)(localisation, key);
    const getSetting = (key)=>(0, _lodash.get)(settings, key);
    const countryName = getLocalisation('country.name');
    const data = vaccinations.map((vaccination)=>({
            ...vaccination,
            countryName,
            healthFacility
        }));
    const VaccineCertificateFooter = ()=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: vaccineCertificateStyles.footerContent
        }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: vaccineCertificateStyles.footerLeft
        }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.labelText
        }, getTranslation('pdf.vaccineCertificate.printDate', 'Print date'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.valueText
        }, (0, _getDisplayDate.getDisplayDate)(printedDate), " | "), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.labelText
        }, getTranslation('pdf.vaccineCertificate.printingFacility', 'Printing facility'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.valueText
        }, facilityName || healthFacility, " | "), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.labelText
        }, getTranslation('pdf.vaccineCertificate.printedBy', 'Printed by'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.valueText
        }, printedBy)), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: vaccineCertificateStyles.footerRight
        }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
            style: vaccineCertificateStyles.valueText,
            render: ({ pageNumber, totalPages })=>getTranslation('pdf.pagination', ':currentPage of :totalPages', {
                    replacements: {
                        currentPage: pageNumber,
                        totalPages
                    }
                })
        })));
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: {
            ..._Layout.styles.page,
            paddingBottom: 51
        }
    }, /*#__PURE__*/ _react.default.createElement(_Layout.FixedHeader, null, /*#__PURE__*/ _react.default.createElement(VaccineCertificateHeader, {
        patient: patient
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        render: ({ pageNumber })=>pageNumber > 1 && /*#__PURE__*/ _react.default.createElement(_Layout.PageBreakPadding, null)
    }), watermarkSrc && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermarkSrc
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logoSrc,
        certificateTitle: getTranslation('pdf.vaccineCertificate.title', 'Immunisation Certificate'),
        letterheadConfig: certificateData
    }), /*#__PURE__*/ _react.default.createElement(_PatientDetailsSection.PatientDetailsSection, {
        patient: patient,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        certificateId: certificateId,
        extraFields: extraPatientFields
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        style: {
            ..._Layout.styles.box,
            marginLeft: '18px',
            marginRight: '18px',
            marginBottom: '0px'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.H3, {
        style: {
            marginBottom: 5,
            marginTop: 5
        }
    }, getTranslation('pdf.vaccineCertificate.immunisationHistory', 'Immunisation history')), /*#__PURE__*/ _react.default.createElement(_Table.Table, {
        data: data,
        columns: columns(getTranslation),
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        columnStyle: {
            padding: '10px 5px'
        }
    })), /*#__PURE__*/ _react.default.createElement(_SigningSection.SigningSection, {
        signingSrc: signingSrc,
        getTranslation: getTranslation,
        style: {
            marginTop: 30
        },
        wrap: false
    }), /*#__PURE__*/ _react.default.createElement(_Layout.FixedFooter, null, /*#__PURE__*/ _react.default.createElement(VaccineCertificateFooter, null))));
};
const VaccineCertificate = (0, _languageContext.withLanguageContext)(VaccineCertificateComponent);

//# sourceMappingURL=VaccineCertificate.js.map