"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Text", {
    enumerable: true,
    get: function() {
        return Text;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _languageContext = require("./languageContext");
const _flattenStyles = require("./flattenStyles");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const Text = ({ style, bold, ...props })=>{
    const { makeIntlStyleSheet } = (0, _languageContext.useLanguageContext)();
    const mergedStyle = (0, _flattenStyles.flatten)(style);
    const newStyles = makeIntlStyleSheet({
        ...mergedStyle,
        ...bold && {
            fontFamily: mergedStyle.fontFamily === 'Helvetica-Oblique' ? 'Helvetica-BoldOblique' : 'Helvetica-Bold'
        }
    }, bold);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Text, {
        style: newStyles,
        ...props
    });
};

//# sourceMappingURL=Text.js.map