import React from 'react';
import { Image, StyleSheet, View } from '@react-pdf/renderer';
import { Text } from '../pdf/Text';
const certificateMargins = '0 18px';
export const styles = StyleSheet.create({
    page: {
        fontFamily: 'Helvetica',
        position: 'relative',
        padding: '30 30 0 30',
        color: '#222222'
    },
    logo: {
        position: 'absolute',
        top: 35,
        left: 25,
        width: 70
    },
    row: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    col: {
        width: '50%'
    },
    box: {
        marginBottom: 30
    },
    signature: {
        flexDirection: 'row',
        marginBottom: 20
    },
    signatureText: {
        fontFamily: 'Helvetica-Bold',
        fontWeight: 400,
        width: 100
    },
    line: {
        width: 300,
        borderBottomColor: 'black',
        borderBottomStyle: 'solid'
    },
    signingImage: {
        width: '100%'
    },
    watermarkContainer: {
        position: 'absolute',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        minWidth: '100%',
        minHeight: '100%',
        maxHeight: '100vh',
        maxWidth: '100vw',
        backgroundColor: '#aaaaaa',
        opacity: 0.05,
        flexDirection: 'row',
        justifyContent: 'center',
        alignItems: 'center'
    },
    watermarkImage: {
        objectFit: 'contain'
    },
    vds: {
        position: 'relative',
        top: -30,
        width: 140
    },
    certificateLogo: {
        position: 'absolute',
        top: 0,
        left: 0,
        height: 60,
        width: 120,
        objectFit: 'contain',
        objectPosition: 'top left'
    },
    certificateHeader: {
        margin: 0
    },
    certificateFooter: {
        margin: certificateMargins
    },
    certificateContent: {
        margin: certificateMargins
    },
    fixedHeader: {
        position: 'absolute',
        top: 25,
        right: 50
    },
    fixedFooter: {
        position: 'absolute',
        bottom: 16,
        left: 50,
        right: 50,
        textAlign: 'left'
    },
    pageBreakPadding: {
        height: 26,
        width: '100%'
    },
    lightDivider: {
        borderTop: '0.5 solid #000000',
        marginTop: 10,
        marginBottom: 10
    }
});
export const Row = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.row,
        ...props
    });
export const Col = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.col,
        ...props
    });
export const Box = ({ mt, mb, ...props })=>/*#__PURE__*/ React.createElement(View, {
        style: [
            styles.box,
            {
                marginTop: mt,
                marginBottom: mb
            }
        ],
        ...props
    });
export const Signature = ({ text, fontSize = 12, lineThickness = 1 })=>/*#__PURE__*/ React.createElement(View, {
        style: styles.signature
    }, /*#__PURE__*/ React.createElement(Text, {
        style: {
            ...styles.signatureText,
            fontSize: fontSize
        }
    }, text, ":"), /*#__PURE__*/ React.createElement(View, {
        style: {
            ...styles.line,
            borderBottomWidth: lineThickness
        }
    }));
export const SigningImage = ({ src })=>/*#__PURE__*/ React.createElement(Image, {
        src: src,
        style: styles.signingImage,
        cache: false
    });
export const Watermark = ({ src })=>/*#__PURE__*/ React.createElement(View, {
        style: styles.watermarkContainer
    }, /*#__PURE__*/ React.createElement(Image, {
        src: src,
        style: styles.watermarkImage,
        cache: false
    }));
/* react-pdf doesn't yet support svg images in the Image component so this will need to be either a
png or jpg src image
@see https://github.com/diegomura/react-pdf/issues/1250 */ export const Logo = ({ logoSrc })=>/*#__PURE__*/ React.createElement(Image, {
        src: logoSrc,
        style: styles.logo,
        cache: false
    });
export const VDSImage = ({ src })=>/*#__PURE__*/ React.createElement(Image, {
        src: src,
        style: styles.vds
    });
export const CertificateLogo = ({ logoSrc })=>/*#__PURE__*/ React.createElement(Image, {
        src: logoSrc,
        style: styles.certificateLogo,
        cache: false
    });
export const CertificateHeader = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.certificateHeader,
        ...props
    });
export const CertificateFooter = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.certificateFooter,
        ...props
    });
export const LightDivider = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.lightDivider,
        ...props
    });
export const CertificateContent = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: styles.certificateContent,
        ...props
    });
export const FixedHeader = ({ children, props })=>/*#__PURE__*/ React.createElement(View, {
        fixed: true,
        style: styles.fixedHeader,
        ...props
    }, children);
export const FixedFooter = ({ children, props })=>/*#__PURE__*/ React.createElement(View, {
        fixed: true,
        style: styles.fixedFooter,
        ...props
    }, /*#__PURE__*/ React.createElement(View, {
        style: {
            ...styles.lightDivider,
            borderTopColor: '#888888'
        }
    }), children);
export const PageBreakPadding = ({ size })=>/*#__PURE__*/ React.createElement(View, {
        fixed: true,
        style: {
            ...styles.pageBreakPadding,
            height: size || styles.pageBreakPadding.height
        }
    });

//# sourceMappingURL=Layout.js.map