import React from 'react';
import { ENCOUNTER_TYPE_LABELS, INVOICE_STATUSES, INVOICE_INSURER_PAYMENT_STATUSES, INVOICE_PATIENT_PAYMENT_STATUSES_LABELS, INVOICE_STATUS_LABELS, INVOICE_INSURER_PAYMENT_STATUS_LABELS } from '@tamanu/constants';
import { DataSection } from './DataSection';
import { DataItem } from './DataItem';
import { Col } from '../Layout';
import { formatShort } from '@tamanu/utils/dateTime';
import { useLanguageContext } from '../../pdf/languageContext';
export const InvoiceDetails = ({ encounter, invoice, patient, enablePatientInsurer })=>{
    const { getTranslation } = useLanguageContext();
    const { additionalData: { insurer, insurerPolicyNumber } } = patient;
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(DataSection, {
        title: getTranslation('pdf.invoiceDetails.title', 'Invoice details'),
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.date.label', 'Date'),
        value: formatShort(invoice.date)
    }), enablePatientInsurer && /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('invoice.insurer.label', 'Insurer'),
        value: insurer?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('invoice.invoiceStatus.label', 'Invoice status'),
        value: INVOICE_STATUS_LABELS[invoice.status]
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.admission.label', 'Admission'),
        value: ENCOUNTER_TYPE_LABELS[encounter?.encounterType]
    }), enablePatientInsurer && /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('invoice.policyNumber.label', 'Policy number'),
        value: insurerPolicyNumber
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('invoice.paymentStatus.label', 'Payment status'),
        value: invoice.status === INVOICE_STATUSES.FINALISED ? INVOICE_PATIENT_PAYMENT_STATUSES_LABELS[invoice.patientPaymentStatus] + (invoice.insurerPaymentStatus === INVOICE_INSURER_PAYMENT_STATUSES.REJECTED ? `/${INVOICE_INSURER_PAYMENT_STATUS_LABELS[invoice.insurerPaymentStatus]}` : '') : getTranslation('general.na.label', 'n/a')
    }))));
};

//# sourceMappingURL=InvoiceDetails.js.map