import React from 'react';
import { DataSection } from './DataSection';
import { View } from '@react-pdf/renderer';
import { P } from '../Typography';
import { Col } from '../Layout';
import { getDobWithAge, getPatientWeight, getSex, getVillageName } from '../../patientAccessors';
import { useLanguageContext } from '../../pdf/languageContext';
import { PrintableBarcode } from './PrintableBarcode';
import { renderDataItems } from './renderDataItems';
export const PatientDetailsWithBarcode = ({ patient, getLocalisation })=>{
    const { getTranslation } = useLanguageContext();
    const PATIENT_FIELDS = {
        leftCol: [
            {
                key: 'firstName',
                label: 'First name'
            },
            {
                key: 'lastName',
                label: 'Last name'
            },
            {
                key: 'dateOfBirth',
                label: 'DOB',
                accessor: getDobWithAge
            },
            {
                key: 'sex',
                label: 'Sex',
                accessor: getSex
            },
            {
                key: 'villageName',
                label: 'Village',
                accessor: getVillageName
            }
        ],
        rightCol: [
            ...patient.patientWeight !== undefined ? [
                {
                    key: 'patientWeight',
                    label: 'Patient weight',
                    accessor: getPatientWeight
                }
            ] : [],
            {
                key: 'displayId',
                label: 'Patient ID'
            }
        ]
    };
    return /*#__PURE__*/ React.createElement(DataSection, {
        title: "Patient details"
    }, /*#__PURE__*/ React.createElement(Col, null, renderDataItems(PATIENT_FIELDS.leftCol, patient, getLocalisation, getTranslation)), /*#__PURE__*/ React.createElement(Col, null, renderDataItems(PATIENT_FIELDS.rightCol, patient, getLocalisation, getTranslation), /*#__PURE__*/ React.createElement(View, {
        style: {
            flexDirection: 'row'
        }
    }, /*#__PURE__*/ React.createElement(P, {
        style: {
            marginTop: 9
        },
        fontSize: 9,
        bold: true
    }, "Patient ID barcode:"), /*#__PURE__*/ React.createElement(PrintableBarcode, {
        id: patient.displayId
    }))));
};

//# sourceMappingURL=PatientDetailsWithBarcode.js.map