import { type DurationUnit, type Interval } from 'date-fns';
import { z } from 'zod';
export declare const ISO9075_DATE_FORMAT = "yyyy-MM-dd";
export declare const ISO9075_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
export declare const ISO8061_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ssXXX";
export declare const isISOString: (dateString: string) => boolean;
/**
 *
 * @param date - usually we are working with a ISO9075 date_time_string or date_string but could
 * also be a ISO8061 date string or a date object so we need to gracefully handle all of them.
 * If you know you are working with an ISO9075 date_time_string or date_string, just use parseIso
 * from date-fns
 */
export declare const parseDate: (date: string | Date | null | undefined) => Date | null;
export declare const toDateTimeString: (date: string | Date | null | undefined) => string | null;
export declare const toDateString: (date: string | Date | null | undefined) => string | null;
export declare const getCurrentDateTimeString: () => string;
export declare const getDateTimeSubtractedFromNow: (daysToSubtract: number) => string | null;
export declare const getCurrentDateString: () => string;
/**
 *  Don't use this function when using a datestring or datetimestring column
 */
export declare const getCurrentISO8601DateString: () => string;
export declare const convertISO9075toRFC3339: (dateString: string | null | undefined) => string;
export declare const ageInWeeks: (dob: string) => number;
export declare const ageInMonths: (dob: string) => number;
export declare const ageInYears: (dob: string) => number;
export declare const compareDateStrings: (key?: "asc" | "desc" | "ASC" | "DESC") => (a: {
    date: string;
}, b: {
    date: string;
}) => number;
export type AgeRange = {
    ageMin: number;
    ageMax: number;
    ageUnit: DurationUnit;
};
export declare const doAgeRangesHaveGaps: (rangesArray: AgeRange[]) => boolean;
export declare const doAgeRangesOverlap: (rangesArray: AgeRange[]) => boolean;
export declare const format: (date: string | Date | null | undefined, format: string) => string | null;
export declare const differenceInMilliseconds: (a: number | string | Date, b: number | string | Date) => number;
export declare const locale: string;
export declare const intlFormatDate: (date: string | Date | null | undefined, formatOptions: Intl.DateTimeFormatOptions, fallback?: string) => string;
export declare const formatShortest: (date: string | null | undefined) => string;
export declare const formatShort: (date: string | null | undefined) => string;
export declare const formatTime: (date: string | null | undefined) => string;
export declare const formatTimeWithSeconds: (date: string | null | undefined) => string;
export declare const formatLong: (date: string | null | undefined) => string;
/** "Thu" */
export declare const formatWeekdayShort: (date: string | Date | null | undefined) => string;
export declare const isStartOfThisWeek: (date: Date | number) => boolean;
export declare const datetimeCustomValidation: z.ZodEffects<z.ZodString, string, string>;
export declare const endpointsOfDay: (date: Date | number) => Date[];
/** Returns `true` if and only if `interval1` is a subset of `interval2`. It need not be a strict subset. */
export declare const isIntervalWithinInterval: (interval1: Interval, interval2: Interval) => boolean;
/** Returns `true` if and only if `date` is an element of [`interval.start`, `interval.end`). */
export declare const isWithinIntervalExcludingEnd: (date: Date | number, interval: Interval) => boolean;
export declare const maxValidDate: (dates: (Date | number)[]) => Date | null;
export declare const minValidDate: (dates: (Date | number)[]) => Date | null;
export declare const eachDayInMonth: (date: Date) => import("date-fns").EachDayOfIntervalResult<{
    start: Date;
    end: Date;
}, undefined>;
//# sourceMappingURL=dateTime.d.ts.map