"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "CertificateNotification", {
    enumerable: true,
    get: function() {
        return CertificateNotification;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const _model = require("../types/model");
let CertificateNotification = class CertificateNotification extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            createdBy: _sequelize.DataTypes.STRING,
            type: _sequelize.DataTypes.STRING,
            facilityName: _sequelize.DataTypes.STRING,
            forwardAddress: _sequelize.DataTypes.STRING,
            requireSigning: _sequelize.DataTypes.BOOLEAN,
            status: _sequelize.DataTypes.STRING,
            error: _sequelize.DataTypes.TEXT,
            language: _sequelize.DataTypes.STRING,
            printedDate: (0, _model.dateType)('printedDate')
        }, {
            ...options,
            // Note that if this changes to bidirectional, the SendCertificateNotification task
            // will need to be updated / limited to handle only new publishes!
            syncDirection: _constants.SYNC_DIRECTIONS.PUSH_TO_CENTRAL_THEN_DELETE
        });
    }
    static initRelations(models) {
        this.belongsTo(models.Patient, {
            foreignKey: 'patientId',
            as: 'patient'
        });
        // For test certificates only
        this.belongsTo(models.LabTest, {
            foreignKey: 'labTestId',
            as: 'labTest'
        });
        // For automated emails
        this.belongsTo(models.LabRequest, {
            foreignKey: 'labRequestId',
            as: 'labRequest'
        });
    }
};

//# sourceMappingURL=CertificateNotification.js.map