import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
export declare class InvoiceInsurerPayment extends Model {
    id: string;
    insurerId: string;
    status: string;
    reason?: string;
    invoicePaymentId?: string;
    insurer?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
    static getFullReferenceAssociations(): {
        model: typeof import("./InvoicePayment").InvoicePayment;
        as: string;
    }[];
    static getListReferenceAssociations(models: Models): {
        model: typeof import("./ReferenceData").ReferenceData;
        as: string;
    }[];
}
//# sourceMappingURL=InvoiceInsurerPayment.d.ts.map