import { times } from 'lodash';
import { fake, chance } from '../../fake/index.js';
export const createProgramRegistry = async ({ models, limit, userId, patientId, programRegistryId, conditionCount = chance.integer({
    min: 1,
    max: 5
}) })=>{
    const { PatientProgramRegistration, PatientProgramRegistrationCondition } = models;
    const { id: patientProgramRegistrationId } = await PatientProgramRegistration.create(fake(PatientProgramRegistration, {
        clinicianId: userId,
        patientId,
        programRegistryId
    }));
    await Promise.all(times(conditionCount, ()=>limit(async ()=>{
            await PatientProgramRegistrationCondition.create(fake(PatientProgramRegistrationCondition, {
                patientId,
                programRegistryId,
                patientProgramRegistrationId
            }));
        })));
};

//# sourceMappingURL=programRegistry.js.map