/* eslint-disable no-undef */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    useLanguageContext: function() {
        return useLanguageContext;
    },
    withLanguageContext: function() {
        return withLanguageContext;
    }
});
const _react = /*#__PURE__*/ _interop_require_wildcard(require("react"));
const _lodash = require("lodash");
const _path = /*#__PURE__*/ _interop_require_default(require("path"));
const _constants = require("@tamanu/constants");
const _renderer = require("@react-pdf/renderer");
const _translationFactory = require("../translation/translationFactory");
const _enumRegistry = require("@tamanu/shared/utils/enumRegistry");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const baseDir = typeof __dirname !== 'undefined' ? _path.default.join(__dirname, '../../assets/fonts') : '/fonts';
// body font
_renderer.Font.register({
    family: _constants.FONT.BATTAMBANG,
    fonts: [
        {
            src: _path.default.join(baseDir, 'Battambang-Regular.ttf'),
            fontWeight: 400
        },
        {
            src: _path.default.join(baseDir, 'Battambang-900.ttf'),
            fontWeight: 500
        }
    ]
});
// title font
_renderer.Font.register({
    family: _constants.FONT.MOUL,
    src: _path.default.join(baseDir, 'Moul-Regular.ttf')
});
// title font
_renderer.Font.register({
    family: 'Roboto',
    src: 'https://cdnjs.cloudflare.com/ajax/libs/ink/3.1.10/fonts/Roboto/roboto-bold-webfont.ttf'
});
const boldFont = [
    'Helvetica-BoldOblique',
    'Helvetica-Bold'
];
const LanguageContext = /*#__PURE__*/ (0, _react.createContext)({});
const getDefaultLanguage = ()=>{
    // in client
    if (typeof window === 'object' && 'localStorage' in window) {
        return window.localStorage.getItem('language');
    }
};
const useLanguageContext = ()=>{
    const ctx = (0, _react.useContext)(LanguageContext);
    return ctx;
};
const withLanguageContext = (Component)=>(props)=>{
        const context = useLanguageContext();
        const { language, translations, ...other } = props;
        const contextValue = (0, _react.useMemo)(()=>{
            return {
                makeIntlStyleSheet (style, forceToBodyFontWithGreaterFontWeight) {
                    if (typeof style !== 'object') return {};
                    const currentLanguage = language || getDefaultLanguage();
                    const newStyles = (0, _lodash.cloneDeep)(style);
                    const currentFontFamily = newStyles?.fontFamily;
                    if (currentLanguage === 'km' && currentFontFamily && currentFontFamily !== _constants.FONT.MOUL && currentFontFamily !== _constants.FONT.BATTAMBANG) {
                        if (boldFont.includes(currentFontFamily) && !forceToBodyFontWithGreaterFontWeight) {
                            newStyles.fontFamily = _constants.FONT.MOUL;
                        } else {
                            newStyles.fontFamily = _constants.FONT.BATTAMBANG;
                            if (forceToBodyFontWithGreaterFontWeight) {
                                newStyles.fontWeight = 500;
                            }
                        }
                    }
                    return newStyles;
                },
                getTranslation (stringId, fallback, translationOptions) {
                    const translationFunc = (0, _translationFactory.translationFactory)(translations);
                    const { value } = translationFunc(stringId, fallback, translationOptions);
                    return value;
                },
                getEnumTranslation (enumValues, currentValue) {
                    const translationFunc = (0, _translationFactory.translationFactory)(translations);
                    const fallback = enumValues[currentValue];
                    const stringId = `${(0, _enumRegistry.getEnumPrefix)(enumValues)}.${currentValue}`;
                    const { value } = translationFunc(stringId, fallback);
                    return value;
                }
            };
        }, [
            language,
            translations
        ]);
        // unsure that we are using only one provider for the component tree
        return 'makeIntlStyleSheet' in context ? /*#__PURE__*/ _react.default.createElement(Component, other) : /*#__PURE__*/ _react.default.createElement(LanguageContext.Provider, {
            value: contextValue
        }, /*#__PURE__*/ _react.default.createElement(Component, other));
    };

//# sourceMappingURL=languageContext.js.map