"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "PatientProgramRegistrationCondition", {
    enumerable: true,
    get: function() {
        return PatientProgramRegistrationCondition;
    }
});
const _constants = require("@tamanu/constants");
const _sequelize = require("sequelize");
const _dateTime = require("@tamanu/utils/dateTime");
const _Model = require("./Model");
const _model = require("../types/model");
const _sync = require("../sync");
let PatientProgramRegistrationCondition = class PatientProgramRegistrationCondition extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: (0, _model.dateTimeType)('date', {
                allowNull: false,
                defaultValue: _dateTime.getCurrentDateTimeString
            }),
            deletionDate: (0, _model.dateTimeType)('deletionDate', {
                defaultValue: null
            }),
            conditionCategory: {
                type: _sequelize.DataTypes.STRING,
                defaultValue: 'unknown',
                allowNull: false
            },
            reasonForChange: {
                type: _sequelize.DataTypes.STRING,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.PatientProgramRegistration, {
            foreignKey: {
                name: 'patientProgramRegistrationId',
                allowNull: false
            },
            as: 'patientProgramRegistration'
        });
        this.belongsTo(models.ProgramRegistryCondition, {
            foreignKey: 'programRegistryConditionId',
            as: 'programRegistryCondition'
        });
        this.belongsTo(models.User, {
            foreignKey: 'clinicianId',
            as: 'clinician'
        });
        this.belongsTo(models.User, {
            foreignKey: 'deletionClinicianId',
            as: 'deletionClinician'
        });
    }
    static getFullReferenceAssociations() {
        return [
            'programRegistryCondition'
        ];
    }
    static buildPatientSyncFilter(patientCount, markedForSyncPatientsTable) {
        if (patientCount === 0) {
            return null;
        }
        return `
      WHERE patient_program_registration_id IN (
        SELECT id
        FROM patient_program_registrations
        WHERE patient_id IN (SELECT patient_id FROM ${markedForSyncPatientsTable})
      )
      AND ${this.tableName}.updated_at_sync_tick > :since
    `;
    }
    static buildSyncLookupQueryDetails() {
        return {
            select: (0, _sync.buildSyncLookupSelect)(this, {
                patientId: 'patient_program_registrations.patient_id'
            }),
            joins: [
                `LEFT JOIN patient_program_registrations ON ${this.tableName}.patient_program_registration_id = patient_program_registrations.id`
            ]
        };
    }
};

//# sourceMappingURL=PatientProgramRegistrationCondition.js.map