"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "adjustDataPostSyncPush", {
    enumerable: true,
    get: function() {
        return adjustDataPostSyncPush;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _countSyncSnapshotRecords = require("./countSyncSnapshotRecords");
const _getSyncSnapshotRecordIds = require("./getSyncSnapshotRecordIds");
const _constants = require("./constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const adjustDataPostSyncPush = async (sequelize, persistedModels, sessionId)=>{
    for (const model of Object.values(persistedModels)){
        if (!model.adjustDataPostSyncPush) {
            continue;
        }
        const modelPersistedRecordsCount = await (0, _countSyncSnapshotRecords.countSyncSnapshotRecords)(sequelize, sessionId, _constants.SYNC_SESSION_DIRECTION.INCOMING, model.tableName);
        // Load the persisted record ids in batches to avoid memory issue
        const batchSize = _config.default.sync.adjustDataBatchSize;
        const batchCount = Math.ceil(modelPersistedRecordsCount / batchSize);
        let fromId;
        for(let i = 0; i < batchCount; i++){
            const persistedIds = await (0, _getSyncSnapshotRecordIds.getSyncSnapshotRecordIds)(sequelize, sessionId, _constants.SYNC_SESSION_DIRECTION.INCOMING, model.tableName, batchSize, fromId);
            fromId = persistedIds[persistedIds.length - 1];
            // adjust the data post sync push in batches
            await model.adjustDataPostSyncPush(persistedIds);
        }
    }
};

//# sourceMappingURL=adjustDataPostSyncPush.js.map