"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "resetPassword", {
    enumerable: true,
    get: function() {
        return resetPassword;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sync = require("../../sync");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const resetPassword = _express.default.Router();
resetPassword.post('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { deviceId } = req;
    // no permission needed
    req.flagPermissionChecked();
    const centralServer = new _sync.CentralServerConnection({
        deviceId
    });
    const response = await centralServer.forwardRequest(req, 'resetPassword');
    res.send(response);
}));

//# sourceMappingURL=resetPassword.js.map