"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getAddress: function() {
        return getAddress;
    },
    getClinician: function() {
        return getClinician;
    },
    getDateOfDeath: function() {
        return getDateOfDeath;
    },
    getDob: function() {
        return getDob;
    },
    getDobWithAge: function() {
        return getDobWithAge;
    },
    getEthnicity: function() {
        return getEthnicity;
    },
    getLocationName: function() {
        return getLocationName;
    },
    getName: function() {
        return getName;
    },
    getNationality: function() {
        return getNationality;
    },
    getPassportNumber: function() {
        return getPassportNumber;
    },
    getPatientWeight: function() {
        return getPatientWeight;
    },
    getPlaceOfBirth: function() {
        return getPlaceOfBirth;
    },
    getSex: function() {
        return getSex;
    },
    getTimeOfDeath: function() {
        return getTimeOfDeath;
    },
    getVillage: function() {
        return getVillage;
    },
    getVillageName: function() {
        return getVillageName;
    }
});
const _lodash = require("lodash");
const _getDisplayDate = require("./patientCertificates/getDisplayDate");
const _dateTime = require("@tamanu/utils/dateTime");
const getName = ({ firstName, lastName })=>`${firstName} ${lastName}`;
const getSex = ({ sex })=>`${(0, _lodash.capitalize)(sex)}`;
const getDob = ({ dateOfBirth }, { getLocalisation, getTranslation })=>dateOfBirth ? (0, _getDisplayDate.getDisplayDate)(dateOfBirth, 'dd/MM/yyyy', getLocalisation) : getTranslation('general.fallback.unknown', 'Unknown');
const getDobWithAge = ({ dateOfBirth }, { getTranslation })=>{
    if (!dateOfBirth) return getTranslation('general.fallback.unknown', 'Unknown');
    const dob = (0, _dateTime.formatShort)(dateOfBirth);
    const age = (0, _dateTime.ageInYears)(dateOfBirth);
    return `${dob} (${age} ${getTranslation('dateTime.unit.years', 'years')})`;
};
const getDateOfDeath = ({ dateOfDeath }, { getLocalisation, getTranslation })=>{
    if (!dateOfDeath) return getTranslation('general.fallback.unknown', 'Unknown');
    return (0, _getDisplayDate.getDisplayDate)(dateOfDeath, 'd MMM yyyy', getLocalisation);
};
const getTimeOfDeath = ({ dateOfDeath }, { getLocalisation, getTranslation })=>{
    if (!dateOfDeath) return getTranslation('general.fallback.unknown', 'Unknown');
    return (0, _getDisplayDate.getDisplayDate)(dateOfDeath, 'hh:mma', getLocalisation).toLowerCase();
};
const getPlaceOfBirth = ({ additionalData })=>(additionalData || {}).placeOfBirth;
const getNationality = ({ additionalData })=>((additionalData || {}).nationality || {}).name;
const getPassportNumber = ({ additionalData })=>(additionalData || {}).passport;
const getAddress = ({ additionalData }, { getTranslation })=>{
    const { streetVillage, cityTown, country } = additionalData ?? {};
    if (streetVillage && cityTown && country) {
        return `${streetVillage}, ${cityTown}, ${country.name}`;
    }
    return getTranslation('general.fallback.notApplicable', 'N/A');
};
const getLocationName = ({ location })=>location.locationGroup ? `${location.locationGroup.name}, ${location.name}` : location.name;
const getVillageName = ({ village })=>village?.name;
const getPatientWeight = ({ patientWeight }, { getTranslation })=>patientWeight ? `${patientWeight}${getTranslation('general.localisedField.weightUnit.label', 'kg')}` : '';
const getEthnicity = ({ additionalData })=>additionalData?.ethnicity?.name;
const getClinician = ({ clinician })=>clinician?.displayName;
const getVillage = ({ village })=>village?.name;

//# sourceMappingURL=patientAccessors.js.map