"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    CURRENTLY_AT_TYPES: function() {
        return CURRENTLY_AT_TYPES;
    },
    PROGRAM_REGISTRATION_STATUS_LABELS: function() {
        return PROGRAM_REGISTRATION_STATUS_LABELS;
    },
    PROGRAM_REGISTRY_CONDITION_CATEGORIES: function() {
        return PROGRAM_REGISTRY_CONDITION_CATEGORIES;
    },
    PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS: function() {
        return PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS;
    },
    REGISTRATION_STATUSES: function() {
        return REGISTRATION_STATUSES;
    },
    STATUS_COLOR: function() {
        return STATUS_COLOR;
    }
});
const _colors = require("./colors.js");
const CURRENTLY_AT_TYPES = {
    VILLAGE: 'village',
    FACILITY: 'facility'
};
const REGISTRATION_STATUSES = {
    ACTIVE: 'active',
    INACTIVE: 'inactive',
    RECORDED_IN_ERROR: 'recordedInError'
};
const PROGRAM_REGISTRATION_STATUS_LABELS = {
    [REGISTRATION_STATUSES.ACTIVE]: 'Active',
    [REGISTRATION_STATUSES.INACTIVE]: 'Removed',
    [REGISTRATION_STATUSES.RECORDED_IN_ERROR]: 'Delete'
};
const STATUS_COLOR = {
    purple: _colors.COLORS.purple,
    pink: _colors.COLORS.pink,
    orange: _colors.COLORS.darkOrange,
    yellow: _colors.COLORS.metallicYellow,
    blue: _colors.COLORS.blue,
    green: _colors.COLORS.green,
    grey: _colors.COLORS.grey,
    red: _colors.COLORS.red,
    brown: '#7A492E',
    teal: '#125E7E'
};
const PROGRAM_REGISTRY_CONDITION_CATEGORIES = {
    SUSPECTED: 'suspected',
    UNDER_INVESTIGATION: 'underInvestigation',
    CONFIRMED: 'confirmed',
    UNKNOWN: 'unknown',
    DISPROVEN: 'disproven',
    RESOLVED: 'resolved',
    IN_REMISSION: 'inRemission',
    NOT_APPLICABLE: 'notApplicable',
    RECORDED_IN_ERROR: 'recordedInError'
};
const PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS = {
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.SUSPECTED]: 'Suspected',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.UNDER_INVESTIGATION]: 'Under investigation',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.CONFIRMED]: 'Confirmed',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.UNKNOWN]: 'Unknown',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.DISPROVEN]: 'Disproven',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.RESOLVED]: 'Resolved',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.IN_REMISSION]: 'In remission',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.NOT_APPLICABLE]: 'Not applicable',
    [PROGRAM_REGISTRY_CONDITION_CATEGORIES.RECORDED_IN_ERROR]: 'Recorded in error'
}; // ########################################################################################################

//# sourceMappingURL=programRegistry.js.map