type EnumKeys = keyof typeof registeredEnums;
type EnumValues = (typeof registeredEnums)[EnumKeys];
/**
 * This is a group of all the enums that are registered to be translatable.
 * This allows us to keep track of changes to existing enums or the additional
 * of new enum constants when maintaining translations
 */
export declare const registeredEnums: {
    APPOINTMENT_STATUSES: {
        CONFIRMED: string;
        ARRIVED: string;
        ASSESSED: string;
        SEEN: string;
        NO_SHOW: string;
        CANCELLED: string;
    };
    ATTENDANT_OF_BIRTH_LABELS: {
        [x: string]: string;
    };
    ASSET_NAME_LABELS: {
        [x: string]: string;
    };
    BIRTH_DELIVERY_TYPE_LABELS: {
        [x: string]: string;
    };
    BIRTH_TYPE_LABELS: {
        [x: string]: string;
    };
    BLOOD_LABELS: {
        [x: string]: string;
    };
    DIAGNOSIS_CERTAINTY_LABELS: {
        [x: string]: string;
    };
    DRUG_ROUTE_LABELS: {
        [x: string]: string;
    };
    EDUCATIONAL_ATTAINMENT_LABELS: {
        [x: string]: string;
    };
    ENCOUNTER_TYPE_LABELS: {
        [x: string]: string;
    };
    IMAGING_TYPES: {
        ANGIOGRAM: string;
        COLONOSCOPY: string;
        CT_SCAN: string;
        ECG: string;
        ECHOCARDIOGRAM: string;
        ENDOSCOPY: string;
        FLUROSCOPY: string;
        HOLTER_MONITOR: string;
        MAMMOGRAM: string;
        MAMMOGRAM_SCREEN: string;
        MAMMOGRAM_DIAG: string;
        ORTHOPANTOMOGRAPHY: string;
        MRI: string;
        STRESS_TEST: string;
        ULTRASOUND: string;
        VASCULAR_STUDY: string;
        X_RAY: string;
    };
    IMAGING_REQUEST_STATUS_LABELS: {
        [x: string]: string;
    };
    INJECTION_SITE_LABELS: {
        [x: string]: string;
    };
    INVOICE_INSURER_PAYMENT_STATUS_LABELS: {
        [x: string]: string;
    };
    INVOICE_ITEMS_CATEGORY_LABELS: {
        [x: string]: string;
    };
    INVOICE_PATIENT_PAYMENT_STATUSES_LABELS: {
        [x: string]: string;
    };
    INVOICE_STATUS_LABELS: {
        [x: string]: string;
    };
    LAB_REQUEST_STATUS_LABELS: {
        [x: string]: string;
    };
    LOCATION_AVAILABILITY_STATUS_LABELS: {
        [x: string]: string;
    };
    MANNER_OF_DEATHS: {
        Disease: string;
        Assault: string;
        Accident: string;
        'Legal Intervention': string;
        'Pending Investigation': string;
        'Intentional Self Harm': string;
        War: string;
        'Unknown/Could not be determined': string;
    };
    MARTIAL_STATUS_LABELS: {
        [x: string]: string;
    };
    NOTE_TYPE_LABELS: {
        [x: string]: string;
    };
    PATIENT_ISSUE_LABELS: {
        [x: string]: string;
    };
    PLACE_OF_BIRTH_LABELS: {
        [x: string]: string;
    };
    PLACE_OF_DEATHS: {
        Home: string;
        'Residential institution': string;
        'School or other institution or public administrative area': string;
        'Sports or athletic area': string;
        'Street or highway': string;
        'Trade or service area': string;
        'Industrial or construction area': string;
        'Bush or reserve': string;
        Farm: string;
        Other: string;
    };
    PROGRAM_REGISTRATION_STATUS_LABELS: {
        [x: string]: string;
    };
    PROGRAM_REGISTRY_CONDITION_CATEGORY_LABELS: {
        [x: string]: string;
    };
    REFERRAL_STATUS_LABELS: {
        [x: string]: string;
    };
    REPEATS_LABELS: number[];
    REPEAT_FREQUENCY_LABELS: {
        WEEKLY: string;
        MONTHLY: string;
    };
    REPEAT_FREQUENCY_UNIT_LABELS: {
        WEEKLY: string;
        MONTHLY: string;
    };
    REPEAT_FREQUENCY_UNIT_PLURAL_LABELS: {
        WEEKLY: string;
        MONTHLY: string;
    };
    REPORT_DATA_SOURCE_LABELS: {
        [x: string]: string;
    };
    REPORT_DB_SCHEMA_LABELS: {
        [x: string]: string;
    };
    REPORT_DEFAULT_DATE_RANGES_LABELS: {
        [x: string]: string;
    };
    REPORT_STATUS_LABELS: {
        [x: string]: string;
    };
    SEX_LABELS: {
        [x: string]: string;
    };
    TASK_FREQUENCY_UNIT_LABELS: {
        [x: string]: string;
    };
    TASK_DURATION_UNIT_LABELS: {
        [x: string]: string;
    };
    SOCIAL_MEDIA_LABELS: {
        [x: string]: string;
    };
    TEMPLATE_TYPE_LABELS: {
        [x: string]: string | undefined;
    };
    TITLE_LABELS: {
        [x: string]: string;
    };
    VACCINE_CATEGORY_LABELS: {
        [x: string]: string;
    };
    VACCINE_STATUS_LABELS: {
        [x: string]: string;
    };
};
/**
 * Translation String id Prefix for each enum group
 * @example SEX_LABELS
 * // String ids will be formatted with prefix 'patient.property.sex':
 * ['patient.property.sex.male', 'patient.property.female', 'patient.property.other']
 */
export declare const translationPrefixes: Record<EnumKeys, string>;
export declare const enumRegistry: Set<{
    WEEKLY: string;
    MONTHLY: string;
} | {
    WEEKLY: string;
    MONTHLY: string;
} | {
    WEEKLY: string;
    MONTHLY: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    Home: string;
    'Residential institution': string;
    'School or other institution or public administrative area': string;
    'Sports or athletic area': string;
    'Street or highway': string;
    'Trade or service area': string;
    'Industrial or construction area': string;
    'Bush or reserve': string;
    Farm: string;
    Other: string;
} | {
    Disease: string;
    Assault: string;
    Accident: string;
    'Legal Intervention': string;
    'Pending Investigation': string;
    'Intentional Self Harm': string;
    War: string;
    'Unknown/Could not be determined': string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    CONFIRMED: string;
    ARRIVED: string;
    ASSESSED: string;
    SEEN: string;
    NO_SHOW: string;
    CANCELLED: string;
} | {
    [x: string]: string;
} | {
    ANGIOGRAM: string;
    COLONOSCOPY: string;
    CT_SCAN: string;
    ECG: string;
    ECHOCARDIOGRAM: string;
    ENDOSCOPY: string;
    FLUROSCOPY: string;
    HOLTER_MONITOR: string;
    MAMMOGRAM: string;
    MAMMOGRAM_SCREEN: string;
    MAMMOGRAM_DIAG: string;
    ORTHOPANTOMOGRAPHY: string;
    MRI: string;
    STRESS_TEST: string;
    ULTRASOUND: string;
    VASCULAR_STUDY: string;
    X_RAY: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string | undefined;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | number[] | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
} | {
    [x: string]: string;
}>;
/** Map holds pairs of key: enum object reference and value: translation prefix as value */
export declare const prefixMap: Map<EnumValues, string>;
/** The list of all translatable enums string id and fallback */
export declare const enumTranslations: any[][];
export {};
//# sourceMappingURL=enumRegistry.d.ts.map