"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.addColumn('encounter_medications', 'repeats', {
            type: Sequelize.INTEGER
        });
        await query.addColumn('encounter_medications', 'is_discharge', {
            type: Sequelize.BOOLEAN,
            allowNull: false,
            defaultValue: false
        });
    },
    down: async (query)=>{
        await query.removeColumn('encounter_medications', 'repeats');
        await query.removeColumn('encounter_medications', 'is_discharge');
    }
};

//# sourceMappingURL=052_addNewColumnsToEncounterMedication.js.map