"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.createTable('reference_drugs', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
        },
        reference_data_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            unique: true,
            references: {
                model: 'reference_data',
                key: 'id'
            }
        },
        route: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        units: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        notes: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    const drugsReferenceData = await query.sequelize.query(`
    SELECT id from reference_data WHERE type = 'drug';
  `);
    if (drugsReferenceData[0].length) {
        await query.bulkInsert('reference_drugs', drugsReferenceData[0].map((it)=>({
                reference_data_id: it.id
            })));
    }
}
async function down(query) {
    await query.dropTable('reference_drugs');
}

//# sourceMappingURL=1739750741784-addReferenceDrugsTable.js.map