"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "createProgramRegistry", {
    enumerable: true,
    get: function() {
        return createProgramRegistry;
    }
});
const _lodash = require("lodash");
const _index = require("../../fake/index.js");
const createProgramRegistry = async ({ models, limit, userId, patientId, programRegistryId, conditionCount = _index.chance.integer({
    min: 1,
    max: 5
}) })=>{
    const { PatientProgramRegistration, PatientProgramRegistrationCondition } = models;
    const { id: patientProgramRegistrationId } = await PatientProgramRegistration.create((0, _index.fake)(PatientProgramRegistration, {
        clinicianId: userId,
        patientId,
        programRegistryId
    }));
    await Promise.all((0, _lodash.times)(conditionCount, ()=>limit(async ()=>{
            await PatientProgramRegistrationCondition.create((0, _index.fake)(PatientProgramRegistrationCondition, {
                patientId,
                programRegistryId,
                patientProgramRegistrationId
            }));
        })));
};

//# sourceMappingURL=programRegistry.js.map