import { Model } from './Model';
import { type InitOptions, type Models } from '../types/model';
export declare class EncounterPausePrescription extends Model {
    id: string;
    encounterPrescriptionId?: string;
    pauseDuration: number;
    pauseTimeUnit: string;
    pauseStartDate: string;
    pauseEndDate: string;
    notes?: string;
    pausingClinicianId?: string;
    createdBy?: string;
    updatedBy?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): {
        select: string;
        joins: string;
    };
    /**
     * Check if a prescription is currently paused
     * @param {string} prescriptionId - The ID of the prescription to check
     * @returns {Promise<{isPaused: boolean, pauseData?: EncounterPausePrescription}>} Whether the medication is paused and the pause data if it is
     */
    static isPrescriptionPaused(prescriptionId: string): Promise<{
        isPaused: boolean;
        pauseData?: EncounterPausePrescription;
    }>;
}
//# sourceMappingURL=EncounterPausePrescription.d.ts.map