"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.configureHoneycombGrpcMetricExporter = void 0;
const exporter_metrics_otlp_grpc_1 = require("@opentelemetry/exporter-metrics-otlp-grpc");
const exporter_utils_1 = require("./exporter-utils");
const honeycomb_options_1 = require("./honeycomb-options");
const grpc_js_1 = require("@grpc/grpc-js");
/**
 * Builds and returns an OTLP Metric exporter that sends data over grpc
 * @param options The {@link HoneycombOptions} used to configure the exporter
 * @returns an {@link OTLPMetricExporter} configured to send telemetry to Honeycomb over grpc
 */
function configureHoneycombGrpcMetricExporter(options) {
    const opts = (0, honeycomb_options_1.computeOptions)(options);
    const metadata = new grpc_js_1.Metadata();
    metadata.set(exporter_utils_1.OTLP_HEADER_KEY, exporter_utils_1.OTLP_PROTO_VERSION);
    metadata.set(exporter_utils_1.TEAM_HEADER_KEY, opts.metricsApiKey || '');
    metadata.set(exporter_utils_1.DATASET_HEADER_KEY, opts.metricsDataset || '');
    return new exporter_metrics_otlp_grpc_1.OTLPMetricExporter({
        url: opts === null || opts === void 0 ? void 0 : opts.metricsEndpoint,
        metadata: metadata,
    });
}
exports.configureHoneycombGrpcMetricExporter = configureHoneycombGrpcMetricExporter;
