import { Model } from './Model';
import type { InitOptions, Models } from '../types/model';
import type { SettingPath } from '@tamanu/settings/types';
declare const SETTINGS_SCOPES_VALUES: ("facility" | "global" | "central")[];
/**
 * Stores nested settings data, where each leaf node in the nested object has a record in the table,
 * with a key based on the full path of keys to get there, joined by dots
 * The model is responsible for providing a nice interface, so that consumers don't have to think
 * about that storage mechanism, instead just setting and getting as they please
 * For e.g.:
 * Setting.set({
 *   schedules: {
 *     outpatientDischarger: {
 *       schedule: '0 11 * * *',
 *       batchSize: 1000,
 *     },
 *     automaticLabTestResultPublisher: false,
 *   },
 * });
 * becomes:
 * id    | key                                       | value
 * xxx   | schedules.outpatientDischarger.schedule   | 0 11 * * *
 * yyy   | schedules.outpatientDischarger.batchSize  | 1000
 * zzz   | schedules.automaticLabTestResultPublisher | false
 */
export declare class Setting extends Model {
    id: string;
    key: string;
    value?: Record<string, any>;
    scope: string;
    facilityId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    /**
     * IMPORTANT: Duplicated from mobile/models/Setting.ts
     * Please update both places when modify
     */
    static get(key?: SettingPath | '', facilityId?: null, scopeOverride?: (typeof SETTINGS_SCOPES_VALUES)[number] | null): Promise<{} | undefined>;
    static set(key: (SettingPath | "") | undefined, value: object, scope?: (typeof SETTINGS_SCOPES_VALUES)[number], facilityId?: null): Promise<void>;
    static buildSyncFilter(): string;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
    }>;
}
export {};
//# sourceMappingURL=Setting.d.ts.map